/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Definition file of the "Device/Lock" "get/set" dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------

    2006-07-25  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file ConfigLockeDlg.h
///  Definition file of the "Device/Lock" "get/set" dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// Configuration Lock Get/Set Test dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CConfigLockDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CConfigLockDlg)

public:
	CConfigLockDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CConfigLockDlg();

// Dialog Data
	enum { IDD = IDD_CONFIGLOCK };

protected:
  unsigned long   m_ulSetTimeout;   //!< Timeout when calling Set Host State
  CComboBox       m_cNewStateCtrl;  //!< Set Host State Combobox Control

  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedBtnGetstate();
  afx_msg void OnBnClickedBtnSetstate();
  afx_msg void OnEnKillfocusEdtTimeout();
  virtual BOOL OnInitDialog();

  virtual void ThreadFunction(void);
  virtual void OnUpdateDevice(CCifXDeviceBase* pcDevice);
};
